function [soc_next, rc1Volt_next, rc2Volt_next, battCurr, battUnfeas, battPrf] = batt2ndOrderModel(soc, rc1Volt, rc2Volt, battPwr, batt, dt)
%batt2ndOrderModel
% 2nd order equivalent circuit model

% ECM parameters
battR0Res = batt.R0(soc);
battR1Res = batt.R1;
battR2Res = batt.R2;

battC1Cap = batt.C1;
battC2Cap = batt.C2;

% Open circuit voltage
battOCVolt = batt.ocv(soc);

% Battery current
b = battOCVolt - battRC1Volt - battRC2Volt;
battCurr = ( 2 .* battPwr ) ./ ( (b) + sqrt( b .^ 2 - 4 .* battR0Res .* battPwr ) );
battCurr = real(battCurr);

% State of charge update
% columbic efficiency
battColumbicEff = ( battCurr > 0 ) + ( battCurr <= 0 ) .* batt.coulombicEff;
soc_new  = - battColumbicEff .* battCurr ./ (batt.nomCap * 3600) .* dt + soc;

% RC voltages update
rc1Volt_next = rc1Volt + battC1Cap .* ( battCurr - rc1Volt ./ battR1Res );
rc2Volt_next = rc2Volt + battC2Cap .* ( battCurr - rc2Volt ./ battR2Res );

% Constraints
battUnfeas = ( battCurr > batt.maxCurr ) | ( battCurr < batt.minCurr ) | ...
    ( soc_new < batt.SOC_lb ) | ( soc_new > batt.SOC_ub );

%% Pack profiles
if isscalar(soc)
    battPrf.battSOC = soc;
    battPrf.battCurr = battCurr;
    battPrf.battOCVolt = battOCVolt;
    battPrf.battVolt = battOCVolt + battCurr * battR0Res + rc1Volt + rc2Volt;
    battPrf.battEqRes = battEqRes;
    battPrf.battUnfeas = battUnfeas;
else
    battPrf = [];
end

end